//#define DEBUG
//#define DEBUGEXPR
//#define YYDEBUG         1


typedef struct linestruct
{
	struct linestruct *next;
	int line;
	int parent;
	int child;
	char *the_str;
} LINE;

typedef struct variablestruct
{
	struct variablestruct *next;
	char name[40];
	int ivalue;
	double value;
	double fnvalue;
	char svalue[1024];
} VARIABLE;

typedef struct varliststruct
{
	VARIABLE *var[99];
	int qty;
} VARLIST;

typedef struct
{
	double values[99];
	int qty;
} EXPRLIST;

typedef struct
{
	long values[99];
	int qty;
} INTLIST;

typedef struct forloopstruct
{
	struct forloopstruct *next;
	LINE *ln;
	VARIABLE *var;
	double tolimit;
	double step;
	LINE *reline;
} NEXT;

typedef struct substruct
{
	struct substruct *next;
	LINE *returnline;
} SUB;

typedef struct openstruct
{
	struct openstruct *next;
	char name[40];
	FILE *fil;
	struct stat file_stat;
	int option_s;
	int option_d;
	int option_l;
	int option_r;
} OPEN;

typedef struct datastruct
{
	struct datastruct *next;
	int line;
	char *data;
} DATA;

typedef struct funcstruct
{
	struct funcstruct *next;
	char name[40];
	VARIABLE *placeholder;
	LINE *fnline;
} FUNC;

extern	VARIABLE *variablebase;
extern	VARIABLE *placeholder;
extern	LINE *linebase;
extern	LINE *current_line;
extern	LINE *next_line;
extern	NEXT *nextbase;
extern	SUB *subbase;
extern	OPEN *openbase;
extern	DATA *database;
extern	FUNC *funcbase;
extern	char the_str[1024];
extern	int the_ptr;
extern	short running;
extern	char run_program[40];

int yylex();
void yyerror(char *);
void addlist(void *,void *);
VARIABLE *reg_variable(char *name,EXPRLIST *);
void text_output(char *);
void file_input(char *,int);
void file_init(void);
void removelist(void *,void *);
void read_data(VARLIST *);
